<?php
// Sécurité : ne doit pas être exécuté s'il n'est pas lancé par le script principal photos-script.php
if ( !defined('OK') )  exit();

////////////////////////////////////////////////////////////////////////////////
////               Génération d'une miniature - icône de film               ////
////////////////////////////////////////////////////////////////////////////////

// Si la variable "taille" est définie, c'est que l'on veut une image seulement.
// 0 -> film "en entier"
// 1 -> taille "n°1" (la première dimension, en pixels ; la plus grande)
// 2 -> taille "n°2" (la seconde, en pixels ; la plus petite)
// $taille, $dim, $cache, $police, $img et $imagecache doivent être définies dans le script appelant.
// On doit se trouver dans le bon répertoire.

switch ($taille) {
// On demande la miniature "de grande taille"
case 1:
  // Vérification de la disponibilité de l'icône générique
  // de grande taille pour les films dans le cache
  $imagefilm = "{$cache}video-$dim.png";
  $taille_police = $dim/30;
  $moitie = $dim/2;
  if ( file_exists($imagefilm) )  {
    $image = imagecreatefrompng($imagefilm);
    eval("\$texte = imagecolorallocate(\$image,$couleur_photos_texte);");
  }
  else  {
    // Génération de l'icône générique pour les films
    $image = imagecreatetruecolor($dim,$dim);
    $noir = imagecolorallocate($image,0,0,0);
    eval("\$fond = imagecolorallocate(\$image,$couleur_photos_fond);");
    eval("\$triangle = imagecolorallocate(\$image,$couleur_films_triangle);");
    eval("\$disque = imagecolorallocate(\$image,$couleur_films_disque);");
    eval("\$texte = imagecolorallocate(\$image,$couleur_photos_texte);");
    imagefilledrectangle($image,1,1,$dim-2,$dim-2,$fond);
    $trois_huitiemes = $dim*3/8;
    // bool imagefilledellipse ( resource image, int cx, int cy, int w, int h, int color )
    imagefilledellipse($image,$moitie,$trois_huitiemes,$moitie,$moitie,$disque);
    // bool imagefilledpolygon ( resource image, array points, int num_points, int color )
    imagefilledpolygon($image,array($trois_huitiemes,$dim*(3-sqrt(3))/8,$dim*3/4,$trois_huitiemes,$trois_huitiemes,$dim*(3+sqrt(3))/8),3,$triangle);
    $taille = imagettfbbox($taille_police,0,$police,"Cliquez sur l'image");
    $taille = abs($taille[6]-$taille[2]);
    imagettftext($image,$taille_police,0,$moitie-$taille/2,$dim*5/8+4*$taille_police,$texte,$police,"Cliquez sur l'image");
    $taille = imagettfbbox($taille_police,0,$police,"pour voir la vidéo");
    $taille = abs($taille[6]-$taille[2]);
    imagettftext($image,$taille_police,0,$moitie-$taille/2,$dim*5/8+6*$taille_police,$texte,$police,"pour voir la vidéo");
    // Sauvegarde dans le cache
    imagepng($image,$imagefilm);
  }
  // Génération de l'icône particulière pour ce film
  $poids = filesize($img)/1024;
  if ( $poids < 1024 )  $poids = "Poids du fichier : " . round($poids) . " Ko";
  else  $poids = "Poids du fichier : " . round($poids/1024) . " Mo";
  $taille = imagettfbbox($taille_police,0,$police,$poids);
  $taille = abs($taille[6]-$taille[2]);
  imagettftext($image,$taille_police,0,$moitie-$taille/2,$dim*5/8+9*$taille_police,$texte,$police,$poids);
  break;

// On demande la miniature "de petite taille"
case 2:
  // Génération de l'icône pour les films, petite taille
  $image = imagecreatetruecolor($dim,$dim);
  $noir = imagecolorallocate($image,0,0,0);
  eval("\$fond = imagecolorallocate(\$image,$couleur_photos_fond);");
  eval("\$triangle = imagecolorallocate(\$image,$couleur_films_triangle);");
  eval("\$disque = imagecolorallocate(\$image,$couleur_films_disque);");
  eval("\$texte = imagecolorallocate(\$image,$couleur_photos_texte);");
  imagefilledrectangle($image,1,1,$dim-2,$dim-2,$fond);
  $moitie = $dim/2;
  $trois_huitiemes = $dim*3/8;
  // bool imagefilledellipse ( resource image, int cx, int cy, int w, int h, int color )
  imagefilledellipse($image,$moitie,$trois_huitiemes,$moitie,$moitie,$disque);
  // bool imagefilledpolygon ( resource image, array points, int num_points, int color )
  imagefilledpolygon($image,array($trois_huitiemes,$dim*(3-sqrt(3))/8,$dim*3/4,$trois_huitiemes,$trois_huitiemes,$dim*(3+sqrt(3))/8),3,$triangle);
  // array imagettfbbox ( float size, float angle, string fontfile, string text )
  $taille = imagettfbbox($dim/8,0,$police,"Vidéo");
  $taille = abs($taille[6]-$taille[2]);
  // array imagettftext ( resource image, float size, float angle, int x, int y, int color, string fontfile, string text )
  imagettftext($image,$dim/8,0,$moitie-$taille/2,$dim*7/8,$texte,$police,"Vidéo");
}

// Sauvegarde dans le cache
imagepng($image,$imagecache);
imagedestroy($image);
?>