<?php
// Sécurité : ne doit pas être exécuté s'il n'est pas lancé par le script principal photos-script.php
if ( !defined('OK') )  exit();

////////////////////////////////////////////////////////////////////////////////////
///////                         Partie administrative                        ///////
////////////////////////////////////////////////////////////////////////////////////

?><!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN"
"http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
  <title>Administration de la galerie</title>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
  <meta http-equiv="Content-Script-Type" content="text/javascript">
  <style type="text/css">
    /* Général */
    html,body { margin-top: 0px; background-color: <?php echo $couleur_html_fond; ?>; }
    h1 { text-align: center; margin-bottom: 1em; color: <?php echo $couleur_html_texte; ?>; }
    h1 a { text-decoration: none; color: black; color: <?php echo $couleur_html_texte; ?>; }
    div { margin-left: 10%; width: 80%; }
    #deconnexion a { text-decoration: none; color: <?php echo $couleur_pages; ?>; font-size: 0.8em; }
    .avertissement { text-align: center; color: <?php echo $couleur_html_texte; ?>; }
    noscript div { text-align: center; font-size: 1.5em; font-weight: 700; }
    #cache { cursor: pointer; text-decoration: underline; text-align: center; font-size: 1.5em; font-weight: 700; }
    #couleurs { text-align: center; }
    #couleurs img { margin: 0px 5%; }
    a:hover { color: <?php echo $couleur_hover; ?> !important; }
    
    /* Pour la gestion du cache */
    #attente { text-align: center; font-size: 1.5em; font-weight: 700; }
    #avancement, #restant { margin-top: 1em; text-align: left; font-size: 0.8em; font-weight: 500; float: left; clear: left; }
    #temps, #temps_restant { padding-top: 1em; text-align: right; font-size: 0.8em; font-weight: 500; }
    #action { margin-left: 15%; width: 70%; margin-top: 3em; }
    #action p { cursor: pointer; text-decoration: underline; text-align: center; font-weight: 700; }
  </style>
</head>
<body>

<p id="deconnexion"><a href="<?php echo $script; ?>?admin&amp;deconnexion">Déconnexion</a></p>

<h1><a href="<?php echo $script; ?>?admin" title="Revenir au sommaire">Administration de la galerie</a></h1>

<?
////////////////////////////////////////////////////////////////////////////////
////                       Gestion de la configuration                      ////
////////////////////////////////////////////////////////////////////////////////
?>
<div id="configuration">

  <h2>Gestion de la configuration</h2>

  <p>Le titre de la galerie est &laquo;&nbsp;<?php echo $titre; ?>&nbsp;&raquo;.</p>

  <p>Le répertoire racine (censé contenir les photos et films originaux) est <?php echo $rep_racine; ?>.<?php
if ( !is_dir($rep_racine) )
  echo " Ce répertoire n'existe pas&nbsp;! Pensez à le créer un jour ou l'autre...";
elseif ( !is_readable($rep_racine) || !is_executable($rep_racine) )
  echo " Ce répertoire n'est pas lisible par l'utilisateur exécutant PHP. Cela signifie que ce script ne pourra pas accéder au contenu de ce répertoire. Pensez à exécuter en console la commande &laquo;&nbsp;chmod -R +rX $rep_racine&nbsp;&raquo;.";
?>
</p>

  <p>Le répertoire cache (censé contenir les miniatures) est <?php echo $cache; ?>.<?php
if ( !is_dir($cache) )
  echo " Ce répertoire n'existe pas&nbsp;! Pensez à le créer un jour ou l'autre...";
elseif ( !is_readable($cache) || !is_writable($cache) || !is_executable($cache) )
  echo " Ce répertoire ne possède pas les bons droits. Il a besoin d'être lisible et inscriptible par l'utilisateur exécutant PHP. Cela signifie que ce script fera des erreurs à chaque mise en cache. Pensez à exécuter en console la commande &laquo;&nbsp;chmod -R u+rwX $cache&nbsp;&raquo;.";
?>
</p>

<?php
if ( !is_file($police) )
  echo "  <p>Le fichier de la police utilisée n'existe pas.</p>\n\n";

if ( strlen($originaux) )
  echo "  <p>Le lien vers les originaux des photos/films est <a href=\"$originaux\">$originaux</a>.</p>\n\n";
else
  echo "  <p>Il n'y a pas de lien vers les originaux des photos/films.</p>\n\n";

$php = PHP_VERSION;
if ( (int) $php{0} < 5 )
  echo "  <p>PHP n'est pas disponible en version 5 ou supérieure. Cela risque de poser des problèmes, vous devriez mettre à jour le moteur PHP.</p>\n\n";

$gd = gd_info();
if ( false === preg_match('/[0-9]/',$gd["GD Version"],$gdversion) )
  echo"  <p>La librairie GD (pour la retouche d'images) n'est visiblement pas installée. La galerie ne pourra pas être fonctionnelle tant que ce ne sera pas le cas.</p>\n\n";
elseif ( (int) $gdversion[0] > 1 )
  echo "  <p>La librairie GD (pour la retouche d'images) est bien installée en version 2 ou supérieure.</p>\n\n";
else
  echo"  <p>La librairie GD (pour la retouche d'images) est installée en version 1, ce qui n'est pas suffisant. La galerie ne pourra pas être fonctionnelle tant que cette librairie ne sera pas disponible en version 2 ou supérieure.</p>\n\n";
?>

  <p>Vérification des couleurs&nbsp;:</p>
  <div id="couleurs">
    <img src="<?php echo $script; ?>?admin&image=1" alt="icône de répertoire">
    <img src="<?php echo $script; ?>?admin&image=2" alt="icône de film">
  </div>

</div>
<?php
// Pour info : pas la peine de vérifier $script, puisque si on voit ces mots, c'est qu'il est correctement configuré.

////////////////////////////////////////////////////////////////////////////////
////                             Gestion du cache                           ////
////////////////////////////////////////////////////////////////////////////////

// On attend que l'utilisateur veuille charger le cache, et on agit.
// C'est de l'AJAX.
?>

<noscript>
  <div>Le JavaScript semble désactivé ou non disponible sur votre navigateur. La (ré)génération du cache via cette interface d'administration a besoin du JavaScript pour fonctionner.</div>
</noscript>

<?php
include("photos-admin.js.php");
?>

<p id="cache" onclick="cache();">
  Visualiser ou modifier le cache.
</p>

</body>
</html>